﻿using System;
using System.Linq;
using Verse;
using RimWorld;
using AdditionalVerb;
using UnityEngine;


namespace yayoShooting
{
	[StaticConstructorOnStartup]
	internal static class yayoShooting
	{
		public static bool using_Ammunition = false;


		static yayoShooting()
		{
			if(ModsConfig.ActiveModsInLoadOrder.Any(mod => mod.PackageId.ToLower() == "LimeTreeSnake.Community.Ammunition".ToLower()))
			{
				using_Ammunition = true;
			}
		}


	}



	[StaticConstructorOnStartup]
	public class VerbProperties_Custom2 : VerbProperties_Custom
	{
		public int ammoUse = 1;


	}

	public class Verb_Shoot_Selected : Verb_Shoot
	{
		public void check()
		{
			if(currentVerb != null)
			{
				verbProps = currentProp;
			}
			
		}

		public override void OnGUI(LocalTargetInfo target)
		{
			// 아이콘 클릭 시 매 틱마다 체크
			check();
			base.OnGUI(target);
		}

		public override bool Available()
		{
			// 매 초마다 체크
			check();
			return base.Available();
		}

		Verb currentVerb
		{
			get
			{
				Comp_VerbSaveable comp = ((CompEquippable)this.DirectOwner).parent.GetComp<Comp_VerbSaveable>();
				return comp.currentVerb;
			}
		}
		VerbProperties currentProp
		{
			get
			{
				return currentVerb.verbProps;
			}
		}





	}









}
